## Excel Text Functions

A set of Excel like functions supported by icCube.



### Return

```
void
```



### Description

A list of Excel Text functions to follow MDX standard.
<UL>
<LI><b>Len</b>(string s), returns the number of characters of the string parameter.
<LI><b>LCase</b>(string s), returns the string parameter converted to lowercase.
<LI><b>Lower</b>(string s), returns the string parameter converted to lowercase.
<LI><b>UCase</b>(string s), returns the string parameter converted to uppercase.
<LI><b>Upper</b>(string s), returns the string parameter converted to uppercase.
<LI><b>Trim</b>(string s), returns the string without left and right
<LI><b>Mid</b>(string s, int start, int length), returns the substring starting at start with the parameter length
<LI><b>Left</b>(string s, int length), returns a string containing the specified length from the left side of a string parameter.
<LI><b>Right</b>(string s, int length), returns a string containing the specified length of characters from the right side of a string parameter.
<LI><b>Concatenate</b>(string s1,string s2 .. string s100), returns a string as concatenation of the parameter strings.
<LI><b>Exact</b>(string s1, string s2), returns true if both string are equal (case sensitive)
<LI><b>Replace</b>(string s, string target, string replacement), replaces each substring of this string that matches the literal target sequence with the specified literal replacement sequence.
<LI><b>Instr</b>([int start,]string s1, string s2), returns the position of the first occurrence of string s2 within s1 (case insensitive). The optional parameter start set the starting position for the search.
</UL>



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Len(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the length of the string parameter

**Query**

```
Len('icCube Rocks')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>12</td></tr></table>


**Assertion : MDX Equals**

```
12
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Lower(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the string parameter converted to lowercase.

**Query**

```
Lower('icCube Rocks')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>iccube rocks</td></tr></table>


**Assertion : MDX Equals**

```
"iccube rocks"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Upper(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the string parameter converted to uppercase.

**Query**

```
Upper('icCube Rocks')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>ICCUBE ROCKS</td></tr></table>


**Assertion : MDX Equals**

```
"ICCUBE ROCKS"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Trim(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the string without left and right.

**Query**

```
Trim(' icCube Rocks ')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>icCube Rocks</td></tr></table>


**Assertion : MDX Equals**

```
"icCube Rocks"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Mid(string,integer,integer)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the substring starting at start with the parameter length.

**Query**

```
Mid('icCube Rocks',3,4)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Cube</td></tr></table>


**Assertion : MDX Equals**

```
"Cube"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Left(string,integer)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Rturns a string containing the specified length from the left side of a string parameter.

**Query**

```
Left('icCube Rocks',6)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>icCube</td></tr></table>


**Assertion : MDX Equals**

```
"icCube"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Right(string,integer)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a string containing the specified length from the right side of a string parameter.

**Query**

```
Right('icCube Rocks',5)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Rocks</td></tr></table>


**Assertion : MDX Equals**

```
"Rocks"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Concatenate(string,string,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a string as concatenation of the parameter strings.

**Query**

```
Concatenate('icCube',' ','Rocks')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>icCube Rocks</td></tr></table>


**Assertion : MDX Equals**

```
"icCube Rocks"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Exact(string,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if both string are equal (case sensitive).

**Query**

```
Exact('icCube','iccube')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
False
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Replace(string,string,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a new string by replacing each matching substring.

**Query**

```
Replace('icCube iCCube icCube Rocks','icCube','I')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>I iCCube I Rocks</td></tr></table>


**Assertion : MDX Equals**

```
"I iCCube I Rocks"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Instr(string,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the position of the first occurrence of string s2 within s1 (case insensitive).

**Query**

```
Instr('Test icCube iCCube icCube Rocks','icCube')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>6</td></tr></table>


**Assertion : MDX Equals**

```
6
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Instr(integer,string,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the position of the first occurrence of string s2 within s1 (case insensitive) starting at start position.

**Query**

```
Instr(7,'Test icCube iCCube icCube Rocks','icCube')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>13</td></tr></table>


**Assertion : MDX Equals**

```
13
```


 
</div>

                                                                                                            

### See Also


[Excel Conversion Functions](Excel%20Conversion%20Functions.md)

[Excel Date Functions](Excel%20Date%20Functions.md)

[Excel Numerical Functions](Excel%20Numerical%20Functions.md)

[Java Functions](Java%20Functions.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
